<?php

use Inertia\Inertia;
use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Application;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AmazonController;
use App\Http\Controllers\ProfileController;

Route::get('/', function () {
    return Inertia::render('Welcome', [
        'canLogin' => Route::has('login'),
        // 'canRegister' => Route::has('register'),
        'laravelVersion' => Application::VERSION,
        'phpVersion' => PHP_VERSION,
    ]);
});
Route::get('/tt',[AmazonController::class,'createCollageFromUrls']);
Route::get('/dashboard', function () {
    return Inertia::render('Dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');



Route::middleware(['auth','role:admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::resource('users', UserController::class);
    Route::get('generate',[HomeController::class,'index'])->name('generate');
    Route::get('generate-affiliate-content',[HomeController::class,'get_products'])->name('get_products');
    Route::get('generate-review-content',[HomeController::class,'get_review_products'])->name('get_review_products');
    Route::get('data/{title}',[HomeController::class,'product_data'])->name('product_data');
    Route::get('content-list',[HomeController::class,'content_list'])->name('content_list');
    Route::get('review-content-list',[HomeController::class,'review_content_list'])->name('review_content_list');
    Route::get('test_collage/{filename}',[HomeController::class,'test'])->name('test_collage');
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
