<div class="entry-content">
@php
// $detail = \App\Models\Product::where('asin', 'B08F28R6C8')->first();
//             $detailed = $detail->contents;
//             dd($detailed);
@endphp
    <p>
        {{ $overview['introduction'] }}
    </p>

    {{-- <div class="code-block" style="margin: 8px auto; text-align: center; display: block; clear: both;">
        <div class="promo-banner">
            <p class="promo-text">
                <span style="font-size:1.5em">🔥</span> 
                <span class="highlight">Black Friday Week</span> Has Started! 
                <span style="font-size:1.5em">🔥</span>
            </p>
        </div>
    </div> --}}

    <div
        style="text-align: center; font-size: small; padding: 10px; box-shadow: 0 1px 5px rgba(0,0,0,0.3); background-color: #f8f8f8; margin: 20px 0;">
        <b>Affiliate disclosure:</b> As an Amazon associate, we'll earn a commission for every successful order through
        our affiliate links in this article. However, you won't be charged anything extra for this.
    </div>

    <div id="toc_container">
        <p class="toc_title">Table of Contents</p>
        <ul class="toc_list">
            @foreach ($overview['table_of_content'] as $item)
                <li><a href="#{{ Str::slug($item) }}">{{ $item }}</a></li>
            @endforeach
        </ul>
    </div>

    <h2 id="{{ Str::slug($overview['table_of_content'][1]) }}">Best Options at a Glance</h2>
    <div class="product-carousel-container">
        <div class="products-grid">
            @foreach ($overview['comparison_snapshot'] as $product)
                @php
                    $product = array_change_key_case($product, CASE_LOWER);
                    $details = \App\Models\Product::where('asin', $product['asin'])->first();

                    // dd($product);

                @endphp
                <div class="product-card">
                    <div class="product-image"><img
                            src="{{ $imgs[$product['asin']]['main_image']['source_url'] ?? '' }}" alt="Shark WANDVAC"
                            class="product-image"></div>
                    <h3 class="product-title">{{ \App\Helpers\ArrayHelper::getValue($product, 'model/variant') }}</h3>
                    <h4 class="product-subtitle">{{ $product['benefits'] }}</h4>
                    <ul class="product-features">
                        <li>{{ \App\Helpers\ArrayHelper::getValue($product, 'item weight') }}</li>
                        <li>{{ \App\Helpers\ArrayHelper::getValue($product, 'material / type') }}</li>
                        <li>{{ \App\Helpers\ArrayHelper::getValue($product, 'use for') }}</li>
                    </ul>
                    <a href="{{ $details->product_url }}?tag={{ env('AFFILIATE_TAG') }}" class="amazon-link"
                        style="text-decoration: none">See on Amazon</a>
                </div>
            @endforeach
        </div>
    </div>

    <h2 id="{{ $overview['table_of_content'][2] }}">{{ $overview['title'] }}</h2>
    @foreach ($overview['comparison_snapshot'] as $product)
        @php
            $product = array_change_key_case($product, CASE_LOWER);
            $detail = \App\Models\Product::where('asin', $product['asin'])->first();
            $detailed = $detail->contents;
            // dump($detailed);
        @endphp
        <div class="prod-review-widget">
            <div class="review-card">
                <div class="review-header">
                    <div class="review-best">{{ \App\Helpers\ArrayHelper::getValue($product, 'model/variant') }}</div>
                    <h2 class="review-title" id="shark_wandvac_cordless_hand_vac">
                        {{ $detailed['title'] }}
                    </h2>
                </div>
                <div class="content-wrapper">
                    <div class="image-container">
                        <img src="{{ $imgs[$product['asin']]['main_image']['source_url']?? '' }}" alt="Shark WANDVAC">
                    </div>
                    <div class="details-container">
                        <div class="specs-container">
                            @foreach ($detailed['quick_summary_snapshot'] as $summery)
                                <div class="spec-item">
                                    <div class="spec-value">
                                        {{ \App\Helpers\ArrayHelper::getValue($summery, 'Parameter') }}</div>
                                    <div class="spec-label">
                                        {{ \App\Helpers\ArrayHelper::getValue($summery, 'Quick Insight') }}</div>
                                </div>
                            @endforeach
                        </div>
                        <a href="{{ $detail->product_url }}?tag={{ env('AFFILIATE_TAG') }}" class="cta-button"
                            style="text-decoration: none"><span class="button-text">Latest Price</span><span
                                class="button-icon">→</span></a>
                    </div>
                </div>
                <div class="pros-cons-content">
                    <div class="pros-cons">
                        <div class="pros">
                            <h3>What You’ll Love</h3>
                            @foreach (\App\Helpers\ArrayHelper::getValue($detailed['benefits_vs_drawbacks'], 'What You’ll Love') as $pro)
                                <div class="pro-item"><span class="pro-icon">✓</span>
                                    <div>{{ $pro }}</div>
                                </div>
                            @endforeach
                        </div>
                        <div class="cons">
                            <h3>What Could Be Better</h3>
                            @foreach (\App\Helpers\ArrayHelper::getValue($detailed['benefits_vs_drawbacks'], 'What You’ll Love') as $cons)
                                <div class="con-item"><span class="con-icon">×</span>
                                    <div>{{ $cons }}</div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="review-section">
                    <div class="review-content">
                        <p>
                            {{ $detailed['introduction'] }}
                        </p>
                    </div>
                    {{-- <div class="review-content">
                        <p>
                            {{ $detailed['product_insight'] }}
                        </p>
                    </div> --}}
                    {{-- <div class="review-content">
                        <p>
                            {{ $detailed['deep_dive_how_it_works'] }}
                        </p>
                    </div> --}}
                    <div class="review-content">
                        <h3>Real World Experience</h3>
                        <p>
                            {{ $detailed['real_world_experience'] }}
                        </p>
                    </div>
                    <div class="gallery-section" id="gallery-1">
                        <div class="main-image-container">
                            <img class="main-image" src="{{ $imgs[$product['asin']]['images'][0]['source_url'] ?? '' }}"
                                alt="Charging Base">
                            <button class="nav-button prev">❮</button>
                            <button class="nav-button next">❯</button>
                        </div>
                        <div class="caption"></div>
                        <div class="thumbnails">
                            @php
                                $imagess = $imgs[$product['asin']]['images'] ?? [];
                            @endphp
                            @foreach ($imagess as $image)
                                <div class="thumbnail-container {{ $loop->first ? 'active' : '' }}">
                                    <img class="thumbnail" src="{{ $image['source_url'] }}">
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="amazon-button-container">
                        <a href="{{ $detail->product_url }}?tag={{ env('AFFILIATE_TAG') }}" class="amazon-button"
                            style="text-decoration: none"><span class="amazon-button-text">Check Price on Amazon</span><span class="button-icon">→</span></a>
                    </div>
                </div>
            </div>
        </div>
    @endforeach

    <h2 id="{{ Str::slug($overview['table_of_content'][4]) }}">Here Are Some Options Where You Can Find</h2>
    @foreach ($overview['options'] as $option)
        <h4>{{ $loop->iteration }}. <a href="{{ $option['url'] }}?tag={{ env('AFFILIATE_TAG') }}"
                style="text-decoration: none; color: #3d3d3d">{{ \App\Helpers\ArrayHelper::getValue($option, 'name') }}.</a>
        </h4>
        <p class="option-description">{{ \App\Helpers\ArrayHelper::getValue($option, 'description') }}</p>
    @endforeach

    <h2 id="{{ Str::slug($overview['table_of_content'][3]) }}">FAQs</h2>
    <div class="faq-section">
        @foreach ($overview['faq'] as $faq)
            <h3>{{ \App\Helpers\ArrayHelper::getValue($faq, 'question') }}</h3>
            <p>{{ \App\Helpers\ArrayHelper::getValue($faq, 'answer') }}</p>
        @endforeach
    </div>

    <h2 id="{{ Str::slug($overview['table_of_content'][4]) }}">The Bottom Line</h2>
    <p>
        {{ $overview['conclusion'] }}
    </p>

</div>
