// Simple Gallery Logic
    document.querySelectorAll('.gallery-section').forEach(gallery => {
        const mainImage = gallery.querySelector('.main-image');
        const thumbnails = gallery.querySelectorAll('.thumbnail-container');
        const prevBtn = gallery.querySelector('.nav-button.prev');
        const nextBtn = gallery.querySelector('.nav-button.next');
        let currentIndex = 0;

        function updateGallery(index) {
            // Update main image source
            const newSrc = thumbnails[index].querySelector('img').src;
            mainImage.src = newSrc;
            
            // Update active styling
            thumbnails.forEach(t => t.classList.remove('active'));
            thumbnails[index].classList.add('active');
            
            currentIndex = index;
        }

        // Thumbnail Click Events
        thumbnails.forEach((thumb, index) => {
            thumb.addEventListener('click', () => updateGallery(index));
        });

        // Prev/Next Buttons
        if(prevBtn) {
            prevBtn.addEventListener('click', () => {
                let newIndex = currentIndex - 1;
                if(newIndex < 0) newIndex = thumbnails.length - 1;
                updateGallery(newIndex);
            });
        }

        if(nextBtn) {
            nextBtn.addEventListener('click', () => {
                let newIndex = currentIndex + 1;
                if(newIndex >= thumbnails.length) newIndex = 0;
                updateGallery(newIndex);
            });
        }
    });