<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('asin');
            $table->string('url');
            $table->string('main_image');
            $table->json('images');
            $table->string('price');
            $table->text('keywords');
            $table->text('description');
            $table->json('specifications');
            $table->string('filename');
            $table->string('main_image_local');
            $table->json('images_local');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
