<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'resend' => [
        'key' => env('RESEND_KEY'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],
    'openai' => [
        'api_key' => env('OPENAI_API_KEY'),
    ],

    'amazon' => [
        'access_key'   => env('AMAZON_ACCESS_KEY'),
        'secret_key'   => env('AMAZON_SECRET_KEY'),
        'partner_tag'  => env('AMAZON_PARTNER_TAG'),
        'marketplace'  => env('AMAZON_MARKETPLACE'),
        'endpoint'     => env('AMAZON_ENDPOINT'),
        'region'       => env('AMAZON_REGION', 'us-east-1'),
    ],
    'rainforest' => [
        'api_key' => env('RAINFOREST_API_KEY'),
    ],
    'wordpress' => [
        'url' => env('WORDPRESS_URL'),
        'username' => env('WORDPRESS_USERNAME'),
        'application_password' => env('WORDPRESS_APPLICATION_PASSWORD'),
    ],


];
