<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class WordpressService
{
    public function createPost($title, $content, $featuredImageId = null)
    {
        $wpUrl = config('services.wordpress.url') . "/wp-json/wp/v2/posts";
        $username = config('services.wordpress.username');
        $password = config('services.wordpress.application_password');

        $data = [
            'title'   => $title,
            'content' => $content,
            'status'  => 'publish',
        ];

        if ($featuredImageId) {
            $data['featured_media'] = $featuredImageId;
        }

        $response = Http::withBasicAuth($username, $password)
            ->timeout(260)             // How long to wait for full response
            ->connectTimeout(110)      // How long to wait for connection
            ->retry(3, 2000)
            ->post($wpUrl, $data);

        return json_decode($response->body());
    }
    function uploadMedia($filePath, $fileName)
    {
        $wpUrl = config('services.wordpress.url') . "/wp-json/wp/v2/media";
        $username = config('services.wordpress.username');
        $password = config('services.wordpress.application_password');

        $fileContents = file_get_contents($filePath);

        $response = Http::withBasicAuth($username, $password)
            ->timeout(260)             // How long to wait for full response
            ->connectTimeout(110)      // How long to wait for connection
            ->retry(3, 2000)
            ->attach(
                'file',
                file_get_contents($filePath),
                $fileName
            )
            ->post($wpUrl, [
                'title' => $fileName,
            ]);

        return $response->json();
    }
}
