<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class OpenAIService
{
    public function generateAmazonContent(string $productName, ?string $keywords = null): string
    {
        $prompt = "Write an Amazon listing for the following product:\n";
        $prompt .= "Product: {$productName}\n";
        if ($keywords) {
            $prompt .= "Include these keywords: {$keywords}\n";
        }
        // $prompt .= "Output should include: Title, 5 Bullet Points, and a Product Description.";
        $prompt .= "\nReturn output in valid JSON with keys: title, bullets, description.";

        $response = Http::withToken(config('services.openai.api_key'))
            ->timeout(5060)             // How long to wait for full response
            ->connectTimeout(110)      // How long to wait for connection
            ->retry(3, 2000)
            ->post('https://api.openai.com/v1/chat/completions', [
                'model' => 'gpt-4.1', // or 'gpt-3.5-turbo'
                'messages' => [
                    ['role' => 'system', 'content' => 'You are a helpful assistant that creates optimized content for Amazon product listings.'],
                    ['role' => 'user', 'content' => $prompt],
                ],
                'temperature' => 0.7,
                'max_tokens' => 15000,
            ]);

        return $response->json('choices.0.message.content') ?? 'No response';
    }
    public function generateContent($prompt): string
    {
        $response = Http::withToken(config('services.openai.api_key'))
            ->timeout(5060)             // How long to wait for full response
            ->connectTimeout(110)      // How long to wait for connection
            ->retry(3, 2000)
            ->post('https://api.openai.com/v1/chat/completions', [
                'model' => 'gpt-4.1', // or 'gpt-3.5-turbo'
                'messages' => [
                    ['role' => 'system', 'content' => 'You are a helpful assistant that creates optimized content for Amazon product listings.'],
                    ['role' => 'user', 'content' => $prompt],
                ],
                'temperature' => 0.7,
                'max_tokens' => 15000,
            ]);

        return $response->json('choices.0.message.content') ?? 'No response';
    }
}
