<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\OpenAIService;

class ProductContentController extends Controller
{
    public function __construct(protected OpenAIService $openAI) {}

    public function generate(Request $request)
    {
        $validated = $request->validate([
            'product_name' => 'required|string|max:255',
            'keywords' => 'nullable|string|max:255',
        ]);

        $result = $this->openAI->generateAmazonContent(
            $validated['product_name'],
            $validated['keywords'] ?? null
        );

        return response()->json([
            'success' => true,
            'data' => $result,
        ]);
    }
    
}
