<?php

namespace App\Http\Controllers;

use App\Models\Contents;
use Psy\Util\Str;
use Inertia\Inertia;
use App\Models\Product;
use Illuminate\Support\Js;
use Illuminate\Http\Request;
use App\Services\ImageService;
use App\Services\WordpressService;
use Illuminate\Support\Facades\Http;
use App\Services\AmazonProductService;
use Illuminate\Support\Facades\Storage;

class HomeController extends Controller
{
    public function index()
    {
        return Inertia::render('Home');
    }
    public function get_products()
    {
        return Inertia::render('Products/GetProductsNew');
    }
    public function get_review_products()
    {
        return Inertia::render('Products/GetProductsReview');
    }
    function product_data($title, AmazonProductService $amazon)
    {
        $data = Storage::disk('local')->get('products/' . $title . '.json');
        $data = json_decode($data, true);

        for ($i = 0; $i < ($data['request_parameters']['include_products_count']); $i++) {
            // $d=$amazon->fetch_product_by_asin($data['search_results'][$i]['asin']);

            // $product=new Product();
            // $product->asin=$d['product']['asin'] ?? '';
            // $product->title=$d['product']['title'] ?? '';
            // $product->main_image=$d['product']['main_image']['link'] ?? '';
            // $product->price=$d['product']['buybox_winner']['price']['value'] ?? 0;
            // $product->keywords=$d['product']['keywords'] ?? '';
            // $product->description=$d['product']['description'] ?? '';
            // $product->specifications=json_encode($d['product']['specifications']) ?? '';
            // $product->images=json_encode($d['product']['images']) ?? '';
            // $product->product_url=$d['product']['link'] ?? '';
            // $product->filename=$title.'_'.$i;
            // $product->save();

            // Storage::disk('local')->put(
            //     'products/single/' . $title .'_'.$i. '.json',
            //     json_encode($d, JSON_PRETTY_PRINT)
            // );
        }
        return Inertia::render('Products/ProductData', ['data' => $data]);
    }

    function create_collage(Request $request, ImageService $imageService)
    {
        $asins = $request->input('asins', []);
        $imagePaths = [];
        foreach ($asins as $asin) {
            $product = Product::where('asin', $asin)->first();
            if ($product) {
                $p = $imageService->downloadImage($product->main_image);
                $imagePaths[] = public_path('products/images/' . $p);
            }
        }
        // return $imagePaths;
        $title = '_' . time();
        return $imageService->createCollage($imagePaths, $title);
    }
    function publish_content($filename, WordpressService $wpService, ImageService $imageService)
    {
        $json = Storage::disk('local')->get("products/{$filename}.json");
        $data = json_decode($json, true);
        $requested = $data['request_parameters']['include_products_count'];
        $available = count($data['search_results']);
        $count = min(max(5, $requested), $available);

        $overview = Contents::where('filename', $filename)->first();
        $overview_data=$overview;
        if (!$overview) {
            return "Content not found";
        }
        $products = Product::where('filename', 'like', $filename . '%')->where('main_image_local', '!=', '')->take($count)->get();
        $img=[];
        $imgs=[];
        foreach ($products as $k=>$product) {
            if($k<3){
                $img[]=public_path('images/' . $product->main_image_local);
            }
            
            $imgs[$product->asin]['main_image']=$wpService->uploadMedia(public_path('images/' . $product->main_image_local), $product->main_image_local);
            foreach (($product->images_local) as $im){
                $imgs[$product->asin]['images'][]=$wpService->uploadMedia(public_path('images/' . $im), $im);
            }
        }
        // Storage::disk('local')->put('test.json', json_encode($imgs, JSON_PRETTY_PRINT));
        // dd($imgs);
        $overview = $overview->contents;
        $tt=explode(":", $overview['title']);
        
        $collage=$imageService->createCollage($img, $filename,$tt[0] ?? 'Product Collage');
        $collageData=json_decode($collage->getContent(),true);
        $featuredImageResponse = $wpService->uploadMedia($collageData['path'], basename($collageData['path']));
        
        $htmlContent = view('post', compact('overview', 'filename', 'imgs'))->render();
        $post_title = $overview['title'];
        $post = $wpService->createPost($post_title, $htmlContent, $featuredImageResponse['id'] ?? null);
        $post_data=json_decode(json_encode($post),true);
        $overview_data->wp_contents=$htmlContent;
        $overview_data->title=$overview['title'];
        $overview_data->wp_url=$post_data['link'] ?? null;
        $overview_data->type='affiliate';
        $overview_data->update();
        return $post;
    }
    function publish_review_content($filename, WordpressService $wpService, ImageService $imageService)
    {
        $json = Storage::disk('local')->get("products/{$filename}.json");
        $data = json_decode($json, true);
        $requested = $data['request_parameters']['include_products_count'];
        $available = count($data['search_results']);
        $count = min(max(5, $requested), $available);

        $overview = Contents::where('filename', $filename)->first();
        $overview_data=$overview;
        if (!$overview) {
            return "Content not found";
        }
        $products = Product::where('filename', 'like', $filename . '%')->where('main_image_local', '!=', '')->take($count)->get();
        $img=[];
        $imgs=[];
        foreach ($products as $k=>$product) {
            if($k<3){
                $img[]=public_path('images/' . $product->main_image_local);
            }
            
            $imgs[$product->asin]['main_image']=$wpService->uploadMedia(public_path('images/' . $product->main_image_local), $product->main_image_local);
            foreach (($product->images_local) as $im){
                $imgs[$product->asin]['images'][]=$wpService->uploadMedia(public_path('images/' . $im), $im);
            }
        }
        // Storage::disk('local')->put('test.json', json_encode($imgs, JSON_PRETTY_PRINT));
        // dd($imgs);
        $overview = $overview->contents;
        $tt=explode(":", $overview['title']);
        
        $collage=$imageService->createCollage($img, $filename,$tt[0] ?? 'Product Collage');
        $collageData=json_decode($collage->getContent(),true);
        $featuredImageResponse = $wpService->uploadMedia($collageData['path'], basename($collageData['path']));
        
        $htmlContent = view('review_post', compact('overview', 'filename', 'imgs'))->render();
        $post_title = $overview['title'];
        $post = $wpService->createPost($post_title, $htmlContent, $featuredImageResponse['id'] ?? null);
        $post_data=json_decode(json_encode($post),true);
        $overview_data->wp_contents=$htmlContent;
        $overview_data->title=$overview['title'];
        $overview_data->wp_url=$post_data['link'] ?? null;
        $overview_data->type='review';
        $overview_data->update();
        return $post;
    }
    function content_list(){
        $contents=Contents::where('type','!=','review')->orderBy('created_at','desc')->get();
        return Inertia::render('Contents/ContentList',['contents'=>$contents,'type'=>'affiliate']);
    }
    function review_content_list(){
        $contents=Contents::where('type','review')->orderBy('created_at','desc')->get();
        return Inertia::render('Contents/ContentList',['contents'=>$contents,'type'=>'review']);
    }
    function test($filename = 'test', WordpressService $wpService, ImageService $imageService){
        $products = Product::where('filename', 'like', $filename . '%')->where('main_image_local', '!=', '')->take(3)->get();
        dd($products);
        $img=[];
        $imgs=[];
        foreach ($products as $k=>$product) {
            if($k<3){
                $img[]=public_path('images/' . $product->main_image_local);
            }
        }
        $collage=$imageService->createCollage($img, $filename,'Product Collage');
        $collageData=json_decode($collage->getContent(),true);
        dd($collageData);
    }
}
